/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.ContentHash;
import com.azure.resourcemanager.automation.models.ContentSourceType;
import java.io.IOException;

public final class ContentSource
implements JsonSerializable<ContentSource> {
    private ContentHash hash;
    private ContentSourceType type;
    private String value;
    private String version;

    public ContentHash hash() {
        return this.hash;
    }

    public ContentSource withHash(ContentHash hash) {
        this.hash = hash;
        return this;
    }

    public ContentSourceType type() {
        return this.type;
    }

    public ContentSource withType(ContentSourceType type) {
        this.type = type;
        return this;
    }

    public String value() {
        return this.value;
    }

    public ContentSource withValue(String value) {
        this.value = value;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ContentSource withVersion(String version) {
        this.version = version;
        return this;
    }

    public void validate() {
        if (this.hash() != null) {
            this.hash().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hash", (JsonSerializable)this.hash);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static ContentSource fromJson(JsonReader jsonReader) throws IOException {
        return (ContentSource)jsonReader.readObject(reader -> {
            ContentSource deserializedContentSource = new ContentSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hash".equals(fieldName)) {
                    deserializedContentSource.hash = ContentHash.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContentSource.type = ContentSourceType.fromString(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedContentSource.value = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedContentSource.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContentSource;
        });
    }
}

