/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.CredentialInner;
import java.time.OffsetDateTime;

public interface Credential {
    public String id();

    public String name();

    public String type();

    public String username();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String description();

    public String resourceGroupName();

    public CredentialInner innerModel();

    public Update update();

    public Credential refresh();

    public Credential refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithPassword {
            public Update withPassword(String var1);
        }

        public static interface WithUsername {
            public Update withUsername(String var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithName,
    UpdateStages.WithUsername,
    UpdateStages.WithPassword,
    UpdateStages.WithDescription {
        public Credential apply();

        public Credential apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithCreate
        extends WithDescription {
            public Credential create();

            public Credential create(Context var1);
        }

        public static interface WithPassword {
            public WithCreate withPassword(String var1);
        }

        public static interface WithUsername {
            public WithPassword withUsername(String var1);
        }

        public static interface WithName {
            public WithUsername withName(String var1);
        }

        public static interface WithParentResource {
            public WithName withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithName,
    DefinitionStages.WithUsername,
    DefinitionStages.WithPassword,
    DefinitionStages.WithCreate {
    }
}

