/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.CredentialCreateOrUpdateProperties;
import java.io.IOException;

public final class CredentialCreateOrUpdateParameters
implements JsonSerializable<CredentialCreateOrUpdateParameters> {
    private String name;
    private CredentialCreateOrUpdateProperties innerProperties = new CredentialCreateOrUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(CredentialCreateOrUpdateParameters.class);

    public String name() {
        return this.name;
    }

    public CredentialCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private CredentialCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    public CredentialCreateOrUpdateParameters withUsername(String username) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialCreateOrUpdateProperties();
        }
        this.innerProperties().withUsername(username);
        return this;
    }

    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    public CredentialCreateOrUpdateParameters withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialCreateOrUpdateProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public CredentialCreateOrUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialCreateOrUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CredentialCreateOrUpdateParameters"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model CredentialCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CredentialCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            CredentialCreateOrUpdateParameters deserializedCredentialCreateOrUpdateParameters = new CredentialCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCredentialCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCredentialCreateOrUpdateParameters.innerProperties = CredentialCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialCreateOrUpdateParameters;
        });
    }
}

