/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.CredentialUpdateProperties;
import java.io.IOException;

public final class CredentialUpdateParameters
implements JsonSerializable<CredentialUpdateParameters> {
    private String name;
    private CredentialUpdateProperties innerProperties;

    public String name() {
        return this.name;
    }

    public CredentialUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private CredentialUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String username() {
        return this.innerProperties() == null ? null : this.innerProperties().username();
    }

    public CredentialUpdateParameters withUsername(String username) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialUpdateProperties();
        }
        this.innerProperties().withUsername(username);
        return this;
    }

    public String password() {
        return this.innerProperties() == null ? null : this.innerProperties().password();
    }

    public CredentialUpdateParameters withPassword(String password) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialUpdateProperties();
        }
        this.innerProperties().withPassword(password);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public CredentialUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CredentialUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CredentialUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CredentialUpdateParameters)jsonReader.readObject(reader -> {
            CredentialUpdateParameters deserializedCredentialUpdateParameters = new CredentialUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCredentialUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCredentialUpdateParameters.innerProperties = CredentialUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentialUpdateParameters;
        });
    }
}

