/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.DscCompilationJobInner;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import com.azure.resourcemanager.automation.models.JobProvisioningState;
import com.azure.resourcemanager.automation.models.JobStatus;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public interface DscCompilationJob {
    public String id();

    public String name();

    public String type();

    public DscConfigurationAssociationProperty configuration();

    public String startedBy();

    public UUID jobId();

    public OffsetDateTime creationTime();

    public JobProvisioningState provisioningState();

    public String runOn();

    public JobStatus status();

    public String statusDetails();

    public OffsetDateTime startTime();

    public OffsetDateTime endTime();

    public String exception();

    public OffsetDateTime lastModifiedTime();

    public OffsetDateTime lastStatusModifiedTime();

    public Map<String, String> parameters();

    public DscCompilationJobInner innerModel();

    public DscCompilationJob refresh();

    public DscCompilationJob refresh(Context var1);

    public static interface DefinitionStages {

        public static interface WithIncrementNodeConfigurationBuild {
            public WithCreate withIncrementNodeConfigurationBuild(Boolean var1);
        }

        public static interface WithParameters {
            public WithCreate withParameters(Map<String, String> var1);
        }

        public static interface WithName {
            public WithCreate withName(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithLocation {
            public WithCreate withRegion(Region var1);

            public WithCreate withRegion(String var1);
        }

        public static interface WithCreate
        extends WithLocation,
        WithTags,
        WithName,
        WithParameters,
        WithIncrementNodeConfigurationBuild {
            public DscCompilationJob create();

            public DscCompilationJob create(Context var1);
        }

        public static interface WithConfiguration {
            public WithCreate withConfiguration(DscConfigurationAssociationProperty var1);
        }

        public static interface WithParentResource {
            public WithConfiguration withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithConfiguration,
    DefinitionStages.WithCreate {
    }
}

