/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscCompilationJobCreateProperties;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class DscCompilationJobCreateParameters
implements JsonSerializable<DscCompilationJobCreateParameters> {
    private DscCompilationJobCreateProperties innerProperties = new DscCompilationJobCreateProperties();
    private String name;
    private String location;
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(DscCompilationJobCreateParameters.class);

    private DscCompilationJobCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public DscCompilationJobCreateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public DscCompilationJobCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DscCompilationJobCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public DscConfigurationAssociationProperty configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public DscCompilationJobCreateParameters withConfiguration(DscConfigurationAssociationProperty configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobCreateProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public DscCompilationJobCreateParameters withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobCreateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public Boolean incrementNodeConfigurationBuild() {
        return this.innerProperties() == null ? null : this.innerProperties().incrementNodeConfigurationBuild();
    }

    public DscCompilationJobCreateParameters withIncrementNodeConfigurationBuild(Boolean incrementNodeConfigurationBuild) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscCompilationJobCreateProperties();
        }
        this.innerProperties().withIncrementNodeConfigurationBuild(incrementNodeConfigurationBuild);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model DscCompilationJobCreateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DscCompilationJobCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DscCompilationJobCreateParameters)jsonReader.readObject(reader -> {
            DscCompilationJobCreateParameters deserializedDscCompilationJobCreateParameters = new DscCompilationJobCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDscCompilationJobCreateParameters.innerProperties = DscCompilationJobCreateProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDscCompilationJobCreateParameters.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDscCompilationJobCreateParameters.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDscCompilationJobCreateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscCompilationJobCreateParameters;
        });
    }
}

