/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.DscConfigurationInner;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationParameter;
import com.azure.resourcemanager.automation.models.DscConfigurationProvisioningState;
import com.azure.resourcemanager.automation.models.DscConfigurationState;
import java.time.OffsetDateTime;
import java.util.Map;

public interface DscConfiguration {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public DscConfigurationProvisioningState provisioningState();

    public Integer jobCount();

    public Map<String, DscConfigurationParameter> parameters();

    public ContentSource source();

    public DscConfigurationState state();

    public Boolean logVerbose();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public Integer nodeConfigurationCount();

    public String description();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public DscConfigurationInner innerModel();

    public Update update();

    public DscConfiguration refresh();

    public DscConfiguration refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithParameters {
            public Update withParameters(Map<String, DscConfigurationParameter> var1);
        }

        public static interface WithSource {
            public Update withSource(ContentSource var1);
        }

        public static interface WithLogProgress {
            public Update withLogProgress(Boolean var1);
        }

        public static interface WithLogVerbose {
            public Update withLogVerbose(Boolean var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithName,
    UpdateStages.WithLogVerbose,
    UpdateStages.WithLogProgress,
    UpdateStages.WithSource,
    UpdateStages.WithParameters,
    UpdateStages.WithDescription {
        public DscConfiguration apply();

        public DscConfiguration apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithParameters {
            public WithCreate withParameters(Map<String, DscConfigurationParameter> var1);
        }

        public static interface WithLogProgress {
            public WithCreate withLogProgress(Boolean var1);
        }

        public static interface WithLogVerbose {
            public WithCreate withLogVerbose(Boolean var1);
        }

        public static interface WithName {
            public WithCreate withName(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithLocation {
            public WithCreate withRegion(Region var1);

            public WithCreate withRegion(String var1);
        }

        public static interface WithCreate
        extends WithLocation,
        WithTags,
        WithName,
        WithLogVerbose,
        WithLogProgress,
        WithParameters,
        WithDescription {
            public DscConfiguration create();

            public DscConfiguration create(Context var1);
        }

        public static interface WithSource {
            public WithCreate withSource(ContentSource var1);
        }

        public static interface WithParentResource {
            public WithSource withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithSource,
    DefinitionStages.WithCreate {
    }
}

