/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscConfigurationCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationParameter;
import java.io.IOException;
import java.util.Map;

public final class DscConfigurationCreateOrUpdateParameters
implements JsonSerializable<DscConfigurationCreateOrUpdateParameters> {
    private DscConfigurationCreateOrUpdateProperties innerProperties = new DscConfigurationCreateOrUpdateProperties();
    private String name;
    private String location;
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(DscConfigurationCreateOrUpdateParameters.class);

    private DscConfigurationCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public DscConfigurationCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public DscConfigurationCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DscConfigurationCreateOrUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean logVerbose() {
        return this.innerProperties() == null ? null : this.innerProperties().logVerbose();
    }

    public DscConfigurationCreateOrUpdateParameters withLogVerbose(Boolean logVerbose) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withLogVerbose(logVerbose);
        return this;
    }

    public Boolean logProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().logProgress();
    }

    public DscConfigurationCreateOrUpdateParameters withLogProgress(Boolean logProgress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withLogProgress(logProgress);
        return this;
    }

    public ContentSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public DscConfigurationCreateOrUpdateParameters withSource(ContentSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public Map<String, DscConfigurationParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public DscConfigurationCreateOrUpdateParameters withParameters(Map<String, DscConfigurationParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public DscConfigurationCreateOrUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model DscConfigurationCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DscConfigurationCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DscConfigurationCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            DscConfigurationCreateOrUpdateParameters deserializedDscConfigurationCreateOrUpdateParameters = new DscConfigurationCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDscConfigurationCreateOrUpdateParameters.innerProperties = DscConfigurationCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDscConfigurationCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDscConfigurationCreateOrUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDscConfigurationCreateOrUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscConfigurationCreateOrUpdateParameters;
        });
    }
}

