/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscConfigurationInner;
import java.io.IOException;
import java.util.List;

public final class DscConfigurationListResult
implements JsonSerializable<DscConfigurationListResult> {
    private List<DscConfigurationInner> value;
    private String nextLink;
    private Integer totalCount;

    public List<DscConfigurationInner> value() {
        return this.value;
    }

    public DscConfigurationListResult withValue(List<DscConfigurationInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DscConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public DscConfigurationListResult withTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeNumberField("totalCount", (Number)this.totalCount);
        return jsonWriter.writeEndObject();
    }

    public static DscConfigurationListResult fromJson(JsonReader jsonReader) throws IOException {
        return (DscConfigurationListResult)jsonReader.readObject(reader -> {
            DscConfigurationListResult deserializedDscConfigurationListResult = new DscConfigurationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDscConfigurationListResult.value = value = reader.readArray(reader1 -> DscConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDscConfigurationListResult.nextLink = reader.getString();
                    continue;
                }
                if ("totalCount".equals(fieldName)) {
                    deserializedDscConfigurationListResult.totalCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscConfigurationListResult;
        });
    }
}

