/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscConfigurationCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationParameter;
import java.io.IOException;
import java.util.Map;

public final class DscConfigurationUpdateParameters
implements JsonSerializable<DscConfigurationUpdateParameters> {
    private DscConfigurationCreateOrUpdateProperties innerProperties;
    private String name;
    private Map<String, String> tags;

    private DscConfigurationCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public DscConfigurationUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DscConfigurationUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Boolean logVerbose() {
        return this.innerProperties() == null ? null : this.innerProperties().logVerbose();
    }

    public DscConfigurationUpdateParameters withLogVerbose(Boolean logVerbose) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withLogVerbose(logVerbose);
        return this;
    }

    public Boolean logProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().logProgress();
    }

    public DscConfigurationUpdateParameters withLogProgress(Boolean logProgress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withLogProgress(logProgress);
        return this;
    }

    public ContentSource source() {
        return this.innerProperties() == null ? null : this.innerProperties().source();
    }

    public DscConfigurationUpdateParameters withSource(ContentSource source) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withSource(source);
        return this;
    }

    public Map<String, DscConfigurationParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public DscConfigurationUpdateParameters withParameters(Map<String, DscConfigurationParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public DscConfigurationUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DscConfigurationCreateOrUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DscConfigurationUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DscConfigurationUpdateParameters)jsonReader.readObject(reader -> {
            DscConfigurationUpdateParameters deserializedDscConfigurationUpdateParameters = new DscConfigurationUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDscConfigurationUpdateParameters.innerProperties = DscConfigurationCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDscConfigurationUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDscConfigurationUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscConfigurationUpdateParameters;
        });
    }
}

