/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.DscNodeConfigurationInner;
import com.azure.resourcemanager.automation.models.ContentSource;
import com.azure.resourcemanager.automation.models.DscConfigurationAssociationProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public interface DscNodeConfiguration {
    public String id();

    public String name();

    public String type();

    public OffsetDateTime lastModifiedTime();

    public OffsetDateTime creationTime();

    public DscConfigurationAssociationProperty configuration();

    public String source();

    public Long nodeCount();

    public Boolean incrementNodeConfigurationBuild();

    public String resourceGroupName();

    public DscNodeConfigurationInner innerModel();

    public Update update();

    public DscNodeConfiguration refresh();

    public DscNodeConfiguration refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIncrementNodeConfigurationBuild {
            public Update withIncrementNodeConfigurationBuild(Boolean var1);
        }

        public static interface WithConfiguration {
            public Update withConfiguration(DscConfigurationAssociationProperty var1);
        }

        public static interface WithSource {
            public Update withSource(ContentSource var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithName,
    UpdateStages.WithSource,
    UpdateStages.WithConfiguration,
    UpdateStages.WithIncrementNodeConfigurationBuild {
        public DscNodeConfiguration apply();

        public DscNodeConfiguration apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIncrementNodeConfigurationBuild {
            public WithCreate withIncrementNodeConfigurationBuild(Boolean var1);
        }

        public static interface WithConfiguration {
            public WithCreate withConfiguration(DscConfigurationAssociationProperty var1);
        }

        public static interface WithSource {
            public WithCreate withSource(ContentSource var1);
        }

        public static interface WithName {
            public WithCreate withName(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithName,
        WithSource,
        WithConfiguration,
        WithIncrementNodeConfigurationBuild {
            public DscNodeConfiguration create();

            public DscNodeConfiguration create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

