/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscNodeConfigurationInner;
import java.io.IOException;
import java.util.List;

public final class DscNodeConfigurationListResult
implements JsonSerializable<DscNodeConfigurationListResult> {
    private List<DscNodeConfigurationInner> value;
    private String nextLink;
    private Integer totalCount;

    public List<DscNodeConfigurationInner> value() {
        return this.value;
    }

    public DscNodeConfigurationListResult withValue(List<DscNodeConfigurationInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DscNodeConfigurationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public DscNodeConfigurationListResult withTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeNumberField("totalCount", (Number)this.totalCount);
        return jsonWriter.writeEndObject();
    }

    public static DscNodeConfigurationListResult fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeConfigurationListResult)jsonReader.readObject(reader -> {
            DscNodeConfigurationListResult deserializedDscNodeConfigurationListResult = new DscNodeConfigurationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDscNodeConfigurationListResult.value = value = reader.readArray(reader1 -> DscNodeConfigurationInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDscNodeConfigurationListResult.nextLink = reader.getString();
                    continue;
                }
                if ("totalCount".equals(fieldName)) {
                    deserializedDscNodeConfigurationListResult.totalCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeConfigurationListResult;
        });
    }
}

