/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.DscNodeInner;
import java.io.IOException;
import java.util.List;

public final class DscNodeListResult
implements JsonSerializable<DscNodeListResult> {
    private List<DscNodeInner> value;
    private String nextLink;
    private Integer totalCount;

    public List<DscNodeInner> value() {
        return this.value;
    }

    public DscNodeListResult withValue(List<DscNodeInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DscNodeListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public Integer totalCount() {
        return this.totalCount;
    }

    public DscNodeListResult withTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeNumberField("totalCount", (Number)this.totalCount);
        return jsonWriter.writeEndObject();
    }

    public static DscNodeListResult fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeListResult)jsonReader.readObject(reader -> {
            DscNodeListResult deserializedDscNodeListResult = new DscNodeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDscNodeListResult.value = value = reader.readArray(reader1 -> DscNodeInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDscNodeListResult.nextLink = reader.getString();
                    continue;
                }
                if ("totalCount".equals(fieldName)) {
                    deserializedDscNodeListResult.totalCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeListResult;
        });
    }
}

