/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.DscNodeUpdateParametersProperties;
import java.io.IOException;

public final class DscNodeUpdateParameters
implements JsonSerializable<DscNodeUpdateParameters> {
    private String nodeId;
    private DscNodeUpdateParametersProperties properties;

    public String nodeId() {
        return this.nodeId;
    }

    public DscNodeUpdateParameters withNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public DscNodeUpdateParametersProperties properties() {
        return this.properties;
    }

    public DscNodeUpdateParameters withProperties(DscNodeUpdateParametersProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nodeId", this.nodeId);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DscNodeUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DscNodeUpdateParameters)jsonReader.readObject(reader -> {
            DscNodeUpdateParameters deserializedDscNodeUpdateParameters = new DscNodeUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nodeId".equals(fieldName)) {
                    deserializedDscNodeUpdateParameters.nodeId = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDscNodeUpdateParameters.properties = DscNodeUpdateParametersProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscNodeUpdateParameters;
        });
    }
}

