/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.DscReportResourceNavigation;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class DscReportResource
implements JsonSerializable<DscReportResource> {
    private String resourceId;
    private String sourceInfo;
    private List<DscReportResourceNavigation> dependsOn;
    private String moduleName;
    private String moduleVersion;
    private String resourceName;
    private String error;
    private String status;
    private Double durationInSeconds;
    private OffsetDateTime startDate;

    public String resourceId() {
        return this.resourceId;
    }

    public DscReportResource withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public String sourceInfo() {
        return this.sourceInfo;
    }

    public DscReportResource withSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
        return this;
    }

    public List<DscReportResourceNavigation> dependsOn() {
        return this.dependsOn;
    }

    public DscReportResource withDependsOn(List<DscReportResourceNavigation> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public String moduleName() {
        return this.moduleName;
    }

    public DscReportResource withModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public String moduleVersion() {
        return this.moduleVersion;
    }

    public DscReportResource withModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
        return this;
    }

    public String resourceName() {
        return this.resourceName;
    }

    public DscReportResource withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public String error() {
        return this.error;
    }

    public DscReportResource withError(String error) {
        this.error = error;
        return this;
    }

    public String status() {
        return this.status;
    }

    public DscReportResource withStatus(String status) {
        this.status = status;
        return this;
    }

    public Double durationInSeconds() {
        return this.durationInSeconds;
    }

    public DscReportResource withDurationInSeconds(Double durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
        return this;
    }

    public OffsetDateTime startDate() {
        return this.startDate;
    }

    public DscReportResource withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public void validate() {
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("sourceInfo", this.sourceInfo);
        jsonWriter.writeArrayField("dependsOn", this.dependsOn, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("moduleName", this.moduleName);
        jsonWriter.writeStringField("moduleVersion", this.moduleVersion);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeNumberField("durationInSeconds", (Number)this.durationInSeconds);
        jsonWriter.writeStringField("startDate", this.startDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDate));
        return jsonWriter.writeEndObject();
    }

    public static DscReportResource fromJson(JsonReader jsonReader) throws IOException {
        return (DscReportResource)jsonReader.readObject(reader -> {
            DscReportResource deserializedDscReportResource = new DscReportResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedDscReportResource.resourceId = reader.getString();
                    continue;
                }
                if ("sourceInfo".equals(fieldName)) {
                    deserializedDscReportResource.sourceInfo = reader.getString();
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn;
                    deserializedDscReportResource.dependsOn = dependsOn = reader.readArray(reader1 -> DscReportResourceNavigation.fromJson(reader1));
                    continue;
                }
                if ("moduleName".equals(fieldName)) {
                    deserializedDscReportResource.moduleName = reader.getString();
                    continue;
                }
                if ("moduleVersion".equals(fieldName)) {
                    deserializedDscReportResource.moduleVersion = reader.getString();
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedDscReportResource.resourceName = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedDscReportResource.error = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedDscReportResource.status = reader.getString();
                    continue;
                }
                if ("durationInSeconds".equals(fieldName)) {
                    deserializedDscReportResource.durationInSeconds = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("startDate".equals(fieldName)) {
                    deserializedDscReportResource.startDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDscReportResource;
        });
    }
}

