/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.EncryptionKeySourceType;
import com.azure.resourcemanager.automation.models.EncryptionPropertiesIdentity;
import com.azure.resourcemanager.automation.models.KeyVaultProperties;
import java.io.IOException;

public final class EncryptionProperties
implements JsonSerializable<EncryptionProperties> {
    private KeyVaultProperties keyVaultProperties;
    private EncryptionKeySourceType keySource;
    private EncryptionPropertiesIdentity identity;

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public EncryptionProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public EncryptionKeySourceType keySource() {
        return this.keySource;
    }

    public EncryptionProperties withKeySource(EncryptionKeySourceType keySource) {
        this.keySource = keySource;
        return this;
    }

    public EncryptionPropertiesIdentity identity() {
        return this.identity;
    }

    public EncryptionProperties withIdentity(EncryptionPropertiesIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeStringField("keySource", this.keySource == null ? null : this.keySource.toString());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionProperties)jsonReader.readObject(reader -> {
            EncryptionProperties deserializedEncryptionProperties = new EncryptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedEncryptionProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("keySource".equals(fieldName)) {
                    deserializedEncryptionProperties.keySource = EncryptionKeySourceType.fromString(reader.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedEncryptionProperties.identity = EncryptionPropertiesIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionProperties;
        });
    }
}

