/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FieldDefinition
implements JsonSerializable<FieldDefinition> {
    private Boolean isEncrypted;
    private Boolean isOptional;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(FieldDefinition.class);

    public Boolean isEncrypted() {
        return this.isEncrypted;
    }

    public FieldDefinition withIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    public Boolean isOptional() {
        return this.isOptional;
    }

    public FieldDefinition withIsOptional(Boolean isOptional) {
        this.isOptional = isOptional;
        return this;
    }

    public String type() {
        return this.type;
    }

    public FieldDefinition withType(String type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model FieldDefinition"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeBooleanField("isEncrypted", this.isEncrypted);
        jsonWriter.writeBooleanField("isOptional", this.isOptional);
        return jsonWriter.writeEndObject();
    }

    public static FieldDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (FieldDefinition)jsonReader.readObject(reader -> {
            FieldDefinition deserializedFieldDefinition = new FieldDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedFieldDefinition.type = reader.getString();
                    continue;
                }
                if ("isEncrypted".equals(fieldName)) {
                    deserializedFieldDefinition.isEncrypted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isOptional".equals(fieldName)) {
                    deserializedFieldDefinition.isOptional = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFieldDefinition;
        });
    }
}

