/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.HybridRunbookWorkerCreateOrUpdateParameters;
import java.io.IOException;

public final class HybridRunbookWorkerCreateParameters
implements JsonSerializable<HybridRunbookWorkerCreateParameters> {
    private HybridRunbookWorkerCreateOrUpdateParameters innerProperties = new HybridRunbookWorkerCreateOrUpdateParameters();
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(HybridRunbookWorkerCreateParameters.class);

    private HybridRunbookWorkerCreateOrUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public HybridRunbookWorkerCreateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String vmResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().vmResourceId();
    }

    public HybridRunbookWorkerCreateParameters withVmResourceId(String vmResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridRunbookWorkerCreateOrUpdateParameters();
        }
        this.innerProperties().withVmResourceId(vmResourceId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model HybridRunbookWorkerCreateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static HybridRunbookWorkerCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (HybridRunbookWorkerCreateParameters)jsonReader.readObject(reader -> {
            HybridRunbookWorkerCreateParameters deserializedHybridRunbookWorkerCreateParameters = new HybridRunbookWorkerCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedHybridRunbookWorkerCreateParameters.innerProperties = HybridRunbookWorkerCreateOrUpdateParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedHybridRunbookWorkerCreateParameters.name = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridRunbookWorkerCreateParameters;
        });
    }
}

