/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.JobInner;
import com.azure.resourcemanager.automation.models.JobProvisioningState;
import com.azure.resourcemanager.automation.models.JobStatus;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public interface Job {
    public String id();

    public String name();

    public String type();

    public RunbookAssociationProperty runbook();

    public String startedBy();

    public String runOn();

    public UUID jobId();

    public OffsetDateTime creationTime();

    public JobStatus status();

    public String statusDetails();

    public OffsetDateTime startTime();

    public OffsetDateTime endTime();

    public String exception();

    public OffsetDateTime lastModifiedTime();

    public OffsetDateTime lastStatusModifiedTime();

    public Map<String, String> parameters();

    public JobProvisioningState provisioningState();

    public JobInner innerModel();

    public Job refresh();

    public Job refresh(Context var1);

    public Response<Void> suspendWithResponse(String var1, Context var2);

    public void suspend();

    public Response<Void> stopWithResponse(String var1, Context var2);

    public void stop();

    public Response<Void> resumeWithResponse(String var1, Context var2);

    public void resume();

    public static interface DefinitionStages {

        public static interface WithClientRequestId {
            public WithCreate withClientRequestId(String var1);
        }

        public static interface WithRunOn {
            public WithCreate withRunOn(String var1);
        }

        public static interface WithParameters {
            public WithCreate withParameters(Map<String, String> var1);
        }

        public static interface WithRunbook {
            public WithCreate withRunbook(RunbookAssociationProperty var1);
        }

        public static interface WithCreate
        extends WithRunbook,
        WithParameters,
        WithRunOn,
        WithClientRequestId {
            public Job create();

            public Job create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

