/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.JobCreateProperties;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class JobCreateParameters
implements JsonSerializable<JobCreateParameters> {
    private JobCreateProperties innerProperties = new JobCreateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(JobCreateParameters.class);

    private JobCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public RunbookAssociationProperty runbook() {
        return this.innerProperties() == null ? null : this.innerProperties().runbook();
    }

    public JobCreateParameters withRunbook(RunbookAssociationProperty runbook) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobCreateProperties();
        }
        this.innerProperties().withRunbook(runbook);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public JobCreateParameters withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobCreateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public JobCreateParameters withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobCreateProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model JobCreateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (JobCreateParameters)jsonReader.readObject(reader -> {
            JobCreateParameters deserializedJobCreateParameters = new JobCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedJobCreateParameters.innerProperties = JobCreateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobCreateParameters;
        });
    }
}

