/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.JobScheduleCreateProperties;
import com.azure.resourcemanager.automation.models.RunbookAssociationProperty;
import com.azure.resourcemanager.automation.models.ScheduleAssociationProperty;
import java.io.IOException;
import java.util.Map;

public final class JobScheduleCreateParameters
implements JsonSerializable<JobScheduleCreateParameters> {
    private JobScheduleCreateProperties innerProperties = new JobScheduleCreateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(JobScheduleCreateParameters.class);

    private JobScheduleCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public ScheduleAssociationProperty schedule() {
        return this.innerProperties() == null ? null : this.innerProperties().schedule();
    }

    public JobScheduleCreateParameters withSchedule(ScheduleAssociationProperty schedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleCreateProperties();
        }
        this.innerProperties().withSchedule(schedule);
        return this;
    }

    public RunbookAssociationProperty runbook() {
        return this.innerProperties() == null ? null : this.innerProperties().runbook();
    }

    public JobScheduleCreateParameters withRunbook(RunbookAssociationProperty runbook) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleCreateProperties();
        }
        this.innerProperties().withRunbook(runbook);
        return this;
    }

    public String runOn() {
        return this.innerProperties() == null ? null : this.innerProperties().runOn();
    }

    public JobScheduleCreateParameters withRunOn(String runOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleCreateProperties();
        }
        this.innerProperties().withRunOn(runOn);
        return this;
    }

    public Map<String, String> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public JobScheduleCreateParameters withParameters(Map<String, String> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobScheduleCreateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model JobScheduleCreateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobScheduleCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (JobScheduleCreateParameters)jsonReader.readObject(reader -> {
            JobScheduleCreateParameters deserializedJobScheduleCreateParameters = new JobScheduleCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedJobScheduleCreateParameters.innerProperties = JobScheduleCreateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobScheduleCreateParameters;
        });
    }
}

