/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.AutomationKeyName;
import com.azure.resourcemanager.automation.models.AutomationKeyPermissions;
import java.io.IOException;

public final class Key
implements JsonSerializable<Key> {
    private AutomationKeyName keyName;
    private AutomationKeyPermissions permissions;
    private String value;

    public AutomationKeyName keyName() {
        return this.keyName;
    }

    public AutomationKeyPermissions permissions() {
        return this.permissions;
    }

    public String value() {
        return this.value;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static Key fromJson(JsonReader jsonReader) throws IOException {
        return (Key)jsonReader.readObject(reader -> {
            Key deserializedKey = new Key();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("KeyName".equals(fieldName)) {
                    deserializedKey.keyName = AutomationKeyName.fromString(reader.getString());
                    continue;
                }
                if ("Permissions".equals(fieldName)) {
                    deserializedKey.permissions = AutomationKeyPermissions.fromString(reader.getString());
                    continue;
                }
                if ("Value".equals(fieldName)) {
                    deserializedKey.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKey;
        });
    }
}

