/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.LinuxUpdateClasses;
import java.io.IOException;
import java.util.List;

public final class LinuxProperties
implements JsonSerializable<LinuxProperties> {
    private LinuxUpdateClasses includedPackageClassifications;
    private List<String> excludedPackageNameMasks;
    private List<String> includedPackageNameMasks;
    private String rebootSetting;

    public LinuxUpdateClasses includedPackageClassifications() {
        return this.includedPackageClassifications;
    }

    public LinuxProperties withIncludedPackageClassifications(LinuxUpdateClasses includedPackageClassifications) {
        this.includedPackageClassifications = includedPackageClassifications;
        return this;
    }

    public List<String> excludedPackageNameMasks() {
        return this.excludedPackageNameMasks;
    }

    public LinuxProperties withExcludedPackageNameMasks(List<String> excludedPackageNameMasks) {
        this.excludedPackageNameMasks = excludedPackageNameMasks;
        return this;
    }

    public List<String> includedPackageNameMasks() {
        return this.includedPackageNameMasks;
    }

    public LinuxProperties withIncludedPackageNameMasks(List<String> includedPackageNameMasks) {
        this.includedPackageNameMasks = includedPackageNameMasks;
        return this;
    }

    public String rebootSetting() {
        return this.rebootSetting;
    }

    public LinuxProperties withRebootSetting(String rebootSetting) {
        this.rebootSetting = rebootSetting;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("includedPackageClassifications", this.includedPackageClassifications == null ? null : this.includedPackageClassifications.toString());
        jsonWriter.writeArrayField("excludedPackageNameMasks", this.excludedPackageNameMasks, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("includedPackageNameMasks", this.includedPackageNameMasks, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("rebootSetting", this.rebootSetting);
        return jsonWriter.writeEndObject();
    }

    public static LinuxProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LinuxProperties)jsonReader.readObject(reader -> {
            LinuxProperties deserializedLinuxProperties = new LinuxProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("includedPackageClassifications".equals(fieldName)) {
                    deserializedLinuxProperties.includedPackageClassifications = LinuxUpdateClasses.fromString(reader.getString());
                    continue;
                }
                if ("excludedPackageNameMasks".equals(fieldName)) {
                    List excludedPackageNameMasks;
                    deserializedLinuxProperties.excludedPackageNameMasks = excludedPackageNameMasks = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("includedPackageNameMasks".equals(fieldName)) {
                    List includedPackageNameMasks;
                    deserializedLinuxProperties.includedPackageNameMasks = includedPackageNameMasks = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("rebootSetting".equals(fieldName)) {
                    deserializedLinuxProperties.rebootSetting = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinuxProperties;
        });
    }
}

