/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.ModuleInner;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.ModuleErrorInfo;
import com.azure.resourcemanager.automation.models.ModuleProvisioningState;
import java.time.OffsetDateTime;
import java.util.Map;

public interface Module {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public Boolean isGlobal();

    public String version();

    public Long sizeInBytes();

    public Integer activityCount();

    public ModuleProvisioningState provisioningState();

    public ContentLink contentLink();

    public ModuleErrorInfo error();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String description();

    public Boolean isComposite();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ModuleInner innerModel();

    public Update update();

    public Module refresh();

    public Module refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public Module apply();

        public Module apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags {
            public Module create();

            public Module create(Context var1);
        }

        public static interface WithContentLink {
            public WithCreate withContentLink(ContentLink var1);
        }

        public static interface WithParentResource {
            public WithContentLink withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithContentLink,
    DefinitionStages.WithCreate {
    }
}

