/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ModuleCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.ContentLink;
import java.io.IOException;
import java.util.Map;

public final class ModuleCreateOrUpdateParameters
implements JsonSerializable<ModuleCreateOrUpdateParameters> {
    private ModuleCreateOrUpdateProperties innerProperties = new ModuleCreateOrUpdateProperties();
    private String name;
    private String location;
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(ModuleCreateOrUpdateParameters.class);

    private ModuleCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ModuleCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ModuleCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ModuleCreateOrUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ContentLink contentLink() {
        return this.innerProperties() == null ? null : this.innerProperties().contentLink();
    }

    public ModuleCreateOrUpdateParameters withContentLink(ContentLink contentLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleCreateOrUpdateProperties();
        }
        this.innerProperties().withContentLink(contentLink);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ModuleCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ModuleCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ModuleCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            ModuleCreateOrUpdateParameters deserializedModuleCreateOrUpdateParameters = new ModuleCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedModuleCreateOrUpdateParameters.innerProperties = ModuleCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedModuleCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedModuleCreateOrUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedModuleCreateOrUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModuleCreateOrUpdateParameters;
        });
    }
}

