/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ModuleUpdateProperties;
import com.azure.resourcemanager.automation.models.ContentLink;
import java.io.IOException;
import java.util.Map;

public final class ModuleUpdateParameters
implements JsonSerializable<ModuleUpdateParameters> {
    private ModuleUpdateProperties innerProperties;
    private String name;
    private String location;
    private Map<String, String> tags;

    private ModuleUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ModuleUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public ModuleUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ModuleUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ContentLink contentLink() {
        return this.innerProperties() == null ? null : this.innerProperties().contentLink();
    }

    public ModuleUpdateParameters withContentLink(ContentLink contentLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ModuleUpdateProperties();
        }
        this.innerProperties().withContentLink(contentLink);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ModuleUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ModuleUpdateParameters)jsonReader.readObject(reader -> {
            ModuleUpdateParameters deserializedModuleUpdateParameters = new ModuleUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedModuleUpdateParameters.innerProperties = ModuleUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedModuleUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedModuleUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedModuleUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedModuleUpdateParameters;
        });
    }
}

