/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.NodeCountProperties;
import java.io.IOException;

public final class NodeCount
implements JsonSerializable<NodeCount> {
    private String name;
    private NodeCountProperties properties;

    public String name() {
        return this.name;
    }

    public NodeCount withName(String name) {
        this.name = name;
        return this;
    }

    public NodeCountProperties properties() {
        return this.properties;
    }

    public NodeCount withProperties(NodeCountProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static NodeCount fromJson(JsonReader jsonReader) throws IOException {
        return (NodeCount)jsonReader.readObject(reader -> {
            NodeCount deserializedNodeCount = new NodeCount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNodeCount.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNodeCount.properties = NodeCountProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNodeCount;
        });
    }
}

