/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.automation.models.PrivateEndpointProperty;
import com.azure.resourcemanager.automation.models.PrivateLinkServiceConnectionStateProperty;
import java.util.List;

public interface PrivateEndpointConnection {
    public String id();

    public String name();

    public String type();

    public PrivateEndpointProperty privateEndpoint();

    public List<String> groupIds();

    public PrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState();

    public String resourceGroupName();

    public PrivateEndpointConnectionInner innerModel();

    public Update update();

    public PrivateEndpointConnection refresh();

    public PrivateEndpointConnection refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithPrivateLinkServiceConnectionState {
            public Update withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionStateProperty var1);
        }

        public static interface WithGroupIds {
            public Update withGroupIds(List<String> var1);
        }

        public static interface WithPrivateEndpoint {
            public Update withPrivateEndpoint(PrivateEndpointProperty var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithPrivateEndpoint,
    UpdateStages.WithGroupIds,
    UpdateStages.WithPrivateLinkServiceConnectionState {
        public PrivateEndpointConnection apply();

        public PrivateEndpointConnection apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithPrivateLinkServiceConnectionState {
            public WithCreate withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionStateProperty var1);
        }

        public static interface WithGroupIds {
            public WithCreate withGroupIds(List<String> var1);
        }

        public static interface WithPrivateEndpoint {
            public WithCreate withPrivateEndpoint(PrivateEndpointProperty var1);
        }

        public static interface WithCreate
        extends WithPrivateEndpoint,
        WithGroupIds,
        WithPrivateLinkServiceConnectionState {
            public PrivateEndpointConnection create();

            public PrivateEndpointConnection create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

