/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.PythonPackageCreateProperties;
import com.azure.resourcemanager.automation.models.ContentLink;
import java.io.IOException;
import java.util.Map;

public final class PythonPackageCreateParameters
implements JsonSerializable<PythonPackageCreateParameters> {
    private PythonPackageCreateProperties innerProperties = new PythonPackageCreateProperties();
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(PythonPackageCreateParameters.class);

    private PythonPackageCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public PythonPackageCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ContentLink contentLink() {
        return this.innerProperties() == null ? null : this.innerProperties().contentLink();
    }

    public PythonPackageCreateParameters withContentLink(ContentLink contentLink) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PythonPackageCreateProperties();
        }
        this.innerProperties().withContentLink(contentLink);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model PythonPackageCreateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PythonPackageCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (PythonPackageCreateParameters)jsonReader.readObject(reader -> {
            PythonPackageCreateParameters deserializedPythonPackageCreateParameters = new PythonPackageCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedPythonPackageCreateParameters.innerProperties = PythonPackageCreateProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedPythonPackageCreateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPythonPackageCreateParameters;
        });
    }
}

