/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.GraphRunbookType;
import java.io.IOException;

public final class RawGraphicalRunbookContent
implements JsonSerializable<RawGraphicalRunbookContent> {
    private String schemaVersion;
    private String runbookDefinition;
    private GraphRunbookType runbookType;

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public RawGraphicalRunbookContent withSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    public String runbookDefinition() {
        return this.runbookDefinition;
    }

    public RawGraphicalRunbookContent withRunbookDefinition(String runbookDefinition) {
        this.runbookDefinition = runbookDefinition;
        return this;
    }

    public GraphRunbookType runbookType() {
        return this.runbookType;
    }

    public RawGraphicalRunbookContent withRunbookType(GraphRunbookType runbookType) {
        this.runbookType = runbookType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("schemaVersion", this.schemaVersion);
        jsonWriter.writeStringField("runbookDefinition", this.runbookDefinition);
        jsonWriter.writeStringField("runbookType", this.runbookType == null ? null : this.runbookType.toString());
        return jsonWriter.writeEndObject();
    }

    public static RawGraphicalRunbookContent fromJson(JsonReader jsonReader) throws IOException {
        return (RawGraphicalRunbookContent)jsonReader.readObject(reader -> {
            RawGraphicalRunbookContent deserializedRawGraphicalRunbookContent = new RawGraphicalRunbookContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("schemaVersion".equals(fieldName)) {
                    deserializedRawGraphicalRunbookContent.schemaVersion = reader.getString();
                    continue;
                }
                if ("runbookDefinition".equals(fieldName)) {
                    deserializedRawGraphicalRunbookContent.runbookDefinition = reader.getString();
                    continue;
                }
                if ("runbookType".equals(fieldName)) {
                    deserializedRawGraphicalRunbookContent.runbookType = GraphRunbookType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRawGraphicalRunbookContent;
        });
    }
}

