/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.RunbookDraftInner;
import com.azure.resourcemanager.automation.fluent.models.RunbookInner;
import com.azure.resourcemanager.automation.models.ContentLink;
import com.azure.resourcemanager.automation.models.RunbookDraft;
import com.azure.resourcemanager.automation.models.RunbookParameter;
import com.azure.resourcemanager.automation.models.RunbookProvisioningState;
import com.azure.resourcemanager.automation.models.RunbookState;
import com.azure.resourcemanager.automation.models.RunbookTypeEnum;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface Runbook {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public RunbookTypeEnum runbookType();

    public ContentLink publishContentLink();

    public RunbookState state();

    public Boolean logVerbose();

    public Boolean logProgress();

    public Integer logActivityTrace();

    public Integer jobCount();

    public Map<String, RunbookParameter> parameters();

    public List<String> outputTypes();

    public RunbookDraft draft();

    public RunbookProvisioningState provisioningState();

    public String lastModifiedBy();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String description();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public RunbookInner innerModel();

    public Update update();

    public Runbook refresh();

    public Runbook refresh(Context var1);

    public void publish();

    public void publish(Context var1);

    public static interface UpdateStages {

        public static interface WithLogActivityTrace {
            public Update withLogActivityTrace(Integer var1);
        }

        public static interface WithLogProgress {
            public Update withLogProgress(Boolean var1);
        }

        public static interface WithLogVerbose {
            public Update withLogVerbose(Boolean var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithName,
    UpdateStages.WithDescription,
    UpdateStages.WithLogVerbose,
    UpdateStages.WithLogProgress,
    UpdateStages.WithLogActivityTrace {
        public Runbook apply();

        public Runbook apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithLogActivityTrace {
            public WithCreate withLogActivityTrace(Integer var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithPublishContentLink {
            public WithCreate withPublishContentLink(ContentLink var1);
        }

        public static interface WithDraft {
            public WithCreate withDraft(RunbookDraftInner var1);
        }

        public static interface WithLogProgress {
            public WithCreate withLogProgress(Boolean var1);
        }

        public static interface WithLogVerbose {
            public WithCreate withLogVerbose(Boolean var1);
        }

        public static interface WithName {
            public WithCreate withName(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithLocation {
            public WithCreate withRegion(Region var1);

            public WithCreate withRegion(String var1);
        }

        public static interface WithCreate
        extends WithLocation,
        WithTags,
        WithName,
        WithLogVerbose,
        WithLogProgress,
        WithDraft,
        WithPublishContentLink,
        WithDescription,
        WithLogActivityTrace {
            public Runbook create();

            public Runbook create(Context var1);
        }

        public static interface WithRunbookType {
            public WithCreate withRunbookType(RunbookTypeEnum var1);
        }

        public static interface WithParentResource {
            public WithRunbookType withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithRunbookType,
    DefinitionStages.WithCreate {
    }
}

