/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.RunbookUpdateProperties;
import java.io.IOException;
import java.util.Map;

public final class RunbookUpdateParameters
implements JsonSerializable<RunbookUpdateParameters> {
    private RunbookUpdateProperties innerProperties;
    private String name;
    private String location;
    private Map<String, String> tags;

    private RunbookUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public RunbookUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    public String location() {
        return this.location;
    }

    public RunbookUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public RunbookUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public RunbookUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Boolean logVerbose() {
        return this.innerProperties() == null ? null : this.innerProperties().logVerbose();
    }

    public RunbookUpdateParameters withLogVerbose(Boolean logVerbose) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookUpdateProperties();
        }
        this.innerProperties().withLogVerbose(logVerbose);
        return this;
    }

    public Boolean logProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().logProgress();
    }

    public RunbookUpdateParameters withLogProgress(Boolean logProgress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookUpdateProperties();
        }
        this.innerProperties().withLogProgress(logProgress);
        return this;
    }

    public Integer logActivityTrace() {
        return this.innerProperties() == null ? null : this.innerProperties().logActivityTrace();
    }

    public RunbookUpdateParameters withLogActivityTrace(Integer logActivityTrace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunbookUpdateProperties();
        }
        this.innerProperties().withLogActivityTrace(logActivityTrace);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static RunbookUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RunbookUpdateParameters)jsonReader.readObject(reader -> {
            RunbookUpdateParameters deserializedRunbookUpdateParameters = new RunbookUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedRunbookUpdateParameters.innerProperties = RunbookUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRunbookUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRunbookUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedRunbookUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunbookUpdateParameters;
        });
    }
}

