/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.ScheduleInner;
import com.azure.resourcemanager.automation.models.AdvancedSchedule;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import java.time.OffsetDateTime;

public interface Schedule {
    public String id();

    public String name();

    public String type();

    public OffsetDateTime startTime();

    public Double startTimeOffsetMinutes();

    public OffsetDateTime expiryTime();

    public Double expiryTimeOffsetMinutes();

    public Boolean isEnabled();

    public OffsetDateTime nextRun();

    public Double nextRunOffsetMinutes();

    public Object interval();

    public ScheduleFrequency frequency();

    public String timeZone();

    public AdvancedSchedule advancedSchedule();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String description();

    public String resourceGroupName();

    public ScheduleInner innerModel();

    public Update update();

    public Schedule refresh();

    public Schedule refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIsEnabled {
            public Update withIsEnabled(Boolean var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithName {
            public Update withName(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithName,
    UpdateStages.WithDescription,
    UpdateStages.WithIsEnabled {
        public Schedule apply();

        public Schedule apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithAdvancedSchedule {
            public WithCreate withAdvancedSchedule(AdvancedSchedule var1);
        }

        public static interface WithTimeZone {
            public WithCreate withTimeZone(String var1);
        }

        public static interface WithInterval {
            public WithCreate withInterval(Object var1);
        }

        public static interface WithExpiryTime {
            public WithCreate withExpiryTime(OffsetDateTime var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithCreate
        extends WithDescription,
        WithExpiryTime,
        WithInterval,
        WithTimeZone,
        WithAdvancedSchedule {
            public Schedule create();

            public Schedule create(Context var1);
        }

        public static interface WithFrequency {
            public WithCreate withFrequency(ScheduleFrequency var1);
        }

        public static interface WithStartTime {
            public WithFrequency withStartTime(OffsetDateTime var1);
        }

        public static interface WithName {
            public WithStartTime withName(String var1);
        }

        public static interface WithParentResource {
            public WithName withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithName,
    DefinitionStages.WithStartTime,
    DefinitionStages.WithFrequency,
    DefinitionStages.WithCreate {
    }
}

