/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ScheduleCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.AdvancedSchedule;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ScheduleCreateOrUpdateParameters
implements JsonSerializable<ScheduleCreateOrUpdateParameters> {
    private String name;
    private ScheduleCreateOrUpdateProperties innerProperties = new ScheduleCreateOrUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ScheduleCreateOrUpdateParameters.class);

    public String name() {
        return this.name;
    }

    public ScheduleCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private ScheduleCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ScheduleCreateOrUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleCreateOrUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public ScheduleCreateOrUpdateParameters withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleCreateOrUpdateProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.innerProperties() == null ? null : this.innerProperties().expiryTime();
    }

    public ScheduleCreateOrUpdateParameters withExpiryTime(OffsetDateTime expiryTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleCreateOrUpdateProperties();
        }
        this.innerProperties().withExpiryTime(expiryTime);
        return this;
    }

    public Object interval() {
        return this.innerProperties() == null ? null : this.innerProperties().interval();
    }

    public ScheduleCreateOrUpdateParameters withInterval(Object interval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleCreateOrUpdateProperties();
        }
        this.innerProperties().withInterval(interval);
        return this;
    }

    public ScheduleFrequency frequency() {
        return this.innerProperties() == null ? null : this.innerProperties().frequency();
    }

    public ScheduleCreateOrUpdateParameters withFrequency(ScheduleFrequency frequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleCreateOrUpdateProperties();
        }
        this.innerProperties().withFrequency(frequency);
        return this;
    }

    public String timeZone() {
        return this.innerProperties() == null ? null : this.innerProperties().timeZone();
    }

    public ScheduleCreateOrUpdateParameters withTimeZone(String timeZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleCreateOrUpdateProperties();
        }
        this.innerProperties().withTimeZone(timeZone);
        return this;
    }

    public AdvancedSchedule advancedSchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().advancedSchedule();
    }

    public ScheduleCreateOrUpdateParameters withAdvancedSchedule(AdvancedSchedule advancedSchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleCreateOrUpdateProperties();
        }
        this.innerProperties().withAdvancedSchedule(advancedSchedule);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ScheduleCreateOrUpdateParameters"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ScheduleCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            ScheduleCreateOrUpdateParameters deserializedScheduleCreateOrUpdateParameters = new ScheduleCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScheduleCreateOrUpdateParameters.innerProperties = ScheduleCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleCreateOrUpdateParameters;
        });
    }
}

