/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ScheduleInner;
import java.io.IOException;
import java.util.List;

public final class ScheduleListResult
implements JsonSerializable<ScheduleListResult> {
    private List<ScheduleInner> value;
    private String nextLink;

    public List<ScheduleInner> value() {
        return this.value;
    }

    public ScheduleListResult withValue(List<ScheduleInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ScheduleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleListResult)jsonReader.readObject(reader -> {
            ScheduleListResult deserializedScheduleListResult = new ScheduleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedScheduleListResult.value = value = reader.readArray(reader1 -> ScheduleInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedScheduleListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleListResult;
        });
    }
}

