/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.ScheduleUpdateProperties;
import java.io.IOException;

public final class ScheduleUpdateParameters
implements JsonSerializable<ScheduleUpdateParameters> {
    private String name;
    private ScheduleUpdateProperties innerProperties;

    public String name() {
        return this.name;
    }

    public ScheduleUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private ScheduleUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ScheduleUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Boolean isEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isEnabled();
    }

    public ScheduleUpdateParameters withIsEnabled(Boolean isEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleUpdateProperties();
        }
        this.innerProperties().withIsEnabled(isEnabled);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleUpdateParameters)jsonReader.readObject(reader -> {
            ScheduleUpdateParameters deserializedScheduleUpdateParameters = new ScheduleUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedScheduleUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScheduleUpdateParameters.innerProperties = ScheduleUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleUpdateParameters;
        });
    }
}

