/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.SkuNameEnum;
import java.io.IOException;

public final class Sku
implements JsonSerializable<Sku> {
    private SkuNameEnum name;
    private String family;
    private Integer capacity;
    private static final ClientLogger LOGGER = new ClientLogger(Sku.class);

    public SkuNameEnum name() {
        return this.name;
    }

    public Sku withName(SkuNameEnum name) {
        this.name = name;
        return this;
    }

    public String family() {
        return this.family;
    }

    public Sku withFamily(String family) {
        this.family = family;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public Sku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Sku"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("family", this.family);
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static Sku fromJson(JsonReader jsonReader) throws IOException {
        return (Sku)jsonReader.readObject(reader -> {
            Sku deserializedSku = new Sku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSku.name = SkuNameEnum.fromString(reader.getString());
                    continue;
                }
                if ("family".equals(fieldName)) {
                    deserializedSku.family = reader.getString();
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSku.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSku;
        });
    }
}

