/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.SoftwareUpdateConfigurationCollectionItemProperties;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import com.azure.resourcemanager.automation.models.SoftwareUpdateConfigurationTasks;
import com.azure.resourcemanager.automation.models.UpdateConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SoftwareUpdateConfigurationCollectionItem
implements JsonSerializable<SoftwareUpdateConfigurationCollectionItem> {
    private String name;
    private String id;
    private SoftwareUpdateConfigurationCollectionItemProperties innerProperties = new SoftwareUpdateConfigurationCollectionItemProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SoftwareUpdateConfigurationCollectionItem.class);

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    private SoftwareUpdateConfigurationCollectionItemProperties innerProperties() {
        return this.innerProperties;
    }

    public UpdateConfiguration updateConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().updateConfiguration();
    }

    public SoftwareUpdateConfigurationCollectionItem withUpdateConfiguration(UpdateConfiguration updateConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationCollectionItemProperties();
        }
        this.innerProperties().withUpdateConfiguration(updateConfiguration);
        return this;
    }

    public SoftwareUpdateConfigurationTasks tasks() {
        return this.innerProperties() == null ? null : this.innerProperties().tasks();
    }

    public SoftwareUpdateConfigurationCollectionItem withTasks(SoftwareUpdateConfigurationTasks tasks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationCollectionItemProperties();
        }
        this.innerProperties().withTasks(tasks);
        return this;
    }

    public ScheduleFrequency frequency() {
        return this.innerProperties() == null ? null : this.innerProperties().frequency();
    }

    public SoftwareUpdateConfigurationCollectionItem withFrequency(ScheduleFrequency frequency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationCollectionItemProperties();
        }
        this.innerProperties().withFrequency(frequency);
        return this;
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public SoftwareUpdateConfigurationCollectionItem withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationCollectionItemProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public OffsetDateTime lastModifiedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModifiedTime();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime nextRun() {
        return this.innerProperties() == null ? null : this.innerProperties().nextRun();
    }

    public SoftwareUpdateConfigurationCollectionItem withNextRun(OffsetDateTime nextRun) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SoftwareUpdateConfigurationCollectionItemProperties();
        }
        this.innerProperties().withNextRun(nextRun);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SoftwareUpdateConfigurationCollectionItem"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SoftwareUpdateConfigurationCollectionItem fromJson(JsonReader jsonReader) throws IOException {
        return (SoftwareUpdateConfigurationCollectionItem)jsonReader.readObject(reader -> {
            SoftwareUpdateConfigurationCollectionItem deserializedSoftwareUpdateConfigurationCollectionItem = new SoftwareUpdateConfigurationCollectionItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItem.innerProperties = SoftwareUpdateConfigurationCollectionItemProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItem.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSoftwareUpdateConfigurationCollectionItem.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSoftwareUpdateConfigurationCollectionItem;
        });
    }
}

