/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.automation.fluent.models.SourceControlInner;
import com.azure.resourcemanager.automation.models.SourceControlSecurityTokenProperties;
import com.azure.resourcemanager.automation.models.SourceType;
import java.time.OffsetDateTime;

public interface SourceControl {
    public String id();

    public String name();

    public String type();

    public String repoUrl();

    public String branch();

    public String folderPath();

    public Boolean autoSync();

    public Boolean publishRunbook();

    public SourceType sourceType();

    public String description();

    public OffsetDateTime creationTime();

    public OffsetDateTime lastModifiedTime();

    public String resourceGroupName();

    public SourceControlInner innerModel();

    public Update update();

    public SourceControl refresh();

    public SourceControl refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithSecurityToken {
            public Update withSecurityToken(SourceControlSecurityTokenProperties var1);
        }

        public static interface WithPublishRunbook {
            public Update withPublishRunbook(Boolean var1);
        }

        public static interface WithAutoSync {
            public Update withAutoSync(Boolean var1);
        }

        public static interface WithFolderPath {
            public Update withFolderPath(String var1);
        }

        public static interface WithBranch {
            public Update withBranch(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithBranch,
    UpdateStages.WithFolderPath,
    UpdateStages.WithAutoSync,
    UpdateStages.WithPublishRunbook,
    UpdateStages.WithSecurityToken,
    UpdateStages.WithDescription {
        public SourceControl apply();

        public SourceControl apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithSecurityToken {
            public WithCreate withSecurityToken(SourceControlSecurityTokenProperties var1);
        }

        public static interface WithSourceType {
            public WithCreate withSourceType(SourceType var1);
        }

        public static interface WithPublishRunbook {
            public WithCreate withPublishRunbook(Boolean var1);
        }

        public static interface WithAutoSync {
            public WithCreate withAutoSync(Boolean var1);
        }

        public static interface WithFolderPath {
            public WithCreate withFolderPath(String var1);
        }

        public static interface WithBranch {
            public WithCreate withBranch(String var1);
        }

        public static interface WithRepoUrl {
            public WithCreate withRepoUrl(String var1);
        }

        public static interface WithCreate
        extends WithRepoUrl,
        WithBranch,
        WithFolderPath,
        WithAutoSync,
        WithPublishRunbook,
        WithSourceType,
        WithSecurityToken,
        WithDescription {
            public SourceControl create();

            public SourceControl create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingAutomationAccount(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

