/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.SourceControlCreateOrUpdateProperties;
import com.azure.resourcemanager.automation.models.SourceControlSecurityTokenProperties;
import com.azure.resourcemanager.automation.models.SourceType;
import java.io.IOException;

public final class SourceControlCreateOrUpdateParameters
implements JsonSerializable<SourceControlCreateOrUpdateParameters> {
    private SourceControlCreateOrUpdateProperties innerProperties = new SourceControlCreateOrUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SourceControlCreateOrUpdateParameters.class);

    private SourceControlCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String repoUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().repoUrl();
    }

    public SourceControlCreateOrUpdateParameters withRepoUrl(String repoUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlCreateOrUpdateProperties();
        }
        this.innerProperties().withRepoUrl(repoUrl);
        return this;
    }

    public String branch() {
        return this.innerProperties() == null ? null : this.innerProperties().branch();
    }

    public SourceControlCreateOrUpdateParameters withBranch(String branch) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlCreateOrUpdateProperties();
        }
        this.innerProperties().withBranch(branch);
        return this;
    }

    public String folderPath() {
        return this.innerProperties() == null ? null : this.innerProperties().folderPath();
    }

    public SourceControlCreateOrUpdateParameters withFolderPath(String folderPath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlCreateOrUpdateProperties();
        }
        this.innerProperties().withFolderPath(folderPath);
        return this;
    }

    public Boolean autoSync() {
        return this.innerProperties() == null ? null : this.innerProperties().autoSync();
    }

    public SourceControlCreateOrUpdateParameters withAutoSync(Boolean autoSync) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlCreateOrUpdateProperties();
        }
        this.innerProperties().withAutoSync(autoSync);
        return this;
    }

    public Boolean publishRunbook() {
        return this.innerProperties() == null ? null : this.innerProperties().publishRunbook();
    }

    public SourceControlCreateOrUpdateParameters withPublishRunbook(Boolean publishRunbook) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlCreateOrUpdateProperties();
        }
        this.innerProperties().withPublishRunbook(publishRunbook);
        return this;
    }

    public SourceType sourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceType();
    }

    public SourceControlCreateOrUpdateParameters withSourceType(SourceType sourceType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlCreateOrUpdateProperties();
        }
        this.innerProperties().withSourceType(sourceType);
        return this;
    }

    public SourceControlSecurityTokenProperties securityToken() {
        return this.innerProperties() == null ? null : this.innerProperties().securityToken();
    }

    public SourceControlCreateOrUpdateParameters withSecurityToken(SourceControlSecurityTokenProperties securityToken) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlCreateOrUpdateProperties();
        }
        this.innerProperties().withSecurityToken(securityToken);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public SourceControlCreateOrUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlCreateOrUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SourceControlCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            SourceControlCreateOrUpdateParameters deserializedSourceControlCreateOrUpdateParameters = new SourceControlCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedSourceControlCreateOrUpdateParameters.innerProperties = SourceControlCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlCreateOrUpdateParameters;
        });
    }
}

