/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.SourceControlInner;
import java.io.IOException;
import java.util.List;

public final class SourceControlListResult
implements JsonSerializable<SourceControlListResult> {
    private List<SourceControlInner> value;
    private String nextLink;

    public List<SourceControlInner> value() {
        return this.value;
    }

    public SourceControlListResult withValue(List<SourceControlInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public SourceControlListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlListResult)jsonReader.readObject(reader -> {
            SourceControlListResult deserializedSourceControlListResult = new SourceControlListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSourceControlListResult.value = value = reader.readArray(reader1 -> SourceControlInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSourceControlListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlListResult;
        });
    }
}

