/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.TokenType;
import java.io.IOException;

public final class SourceControlSecurityTokenProperties
implements JsonSerializable<SourceControlSecurityTokenProperties> {
    private String accessToken;
    private String refreshToken;
    private TokenType tokenType;

    public String accessToken() {
        return this.accessToken;
    }

    public SourceControlSecurityTokenProperties withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public SourceControlSecurityTokenProperties withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public TokenType tokenType() {
        return this.tokenType;
    }

    public SourceControlSecurityTokenProperties withTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("refreshToken", this.refreshToken);
        jsonWriter.writeStringField("tokenType", this.tokenType == null ? null : this.tokenType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SourceControlSecurityTokenProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlSecurityTokenProperties)jsonReader.readObject(reader -> {
            SourceControlSecurityTokenProperties deserializedSourceControlSecurityTokenProperties = new SourceControlSecurityTokenProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessToken".equals(fieldName)) {
                    deserializedSourceControlSecurityTokenProperties.accessToken = reader.getString();
                    continue;
                }
                if ("refreshToken".equals(fieldName)) {
                    deserializedSourceControlSecurityTokenProperties.refreshToken = reader.getString();
                    continue;
                }
                if ("tokenType".equals(fieldName)) {
                    deserializedSourceControlSecurityTokenProperties.tokenType = TokenType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlSecurityTokenProperties;
        });
    }
}

