/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.SourceControlSyncJobCreateProperties;
import java.io.IOException;

public final class SourceControlSyncJobCreateParameters
implements JsonSerializable<SourceControlSyncJobCreateParameters> {
    private SourceControlSyncJobCreateProperties innerProperties = new SourceControlSyncJobCreateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SourceControlSyncJobCreateParameters.class);

    private SourceControlSyncJobCreateProperties innerProperties() {
        return this.innerProperties;
    }

    public String commitId() {
        return this.innerProperties() == null ? null : this.innerProperties().commitId();
    }

    public SourceControlSyncJobCreateParameters withCommitId(String commitId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SourceControlSyncJobCreateProperties();
        }
        this.innerProperties().withCommitId(commitId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model SourceControlSyncJobCreateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SourceControlSyncJobCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SourceControlSyncJobCreateParameters)jsonReader.readObject(reader -> {
            SourceControlSyncJobCreateParameters deserializedSourceControlSyncJobCreateParameters = new SourceControlSyncJobCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedSourceControlSyncJobCreateParameters.innerProperties = SourceControlSyncJobCreateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSourceControlSyncJobCreateParameters;
        });
    }
}

