/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.AdvancedSchedule;
import com.azure.resourcemanager.automation.models.ScheduleFrequency;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SucScheduleProperties
implements JsonSerializable<SucScheduleProperties> {
    private OffsetDateTime startTime;
    private Double startTimeOffsetMinutes;
    private OffsetDateTime expiryTime;
    private Double expiryTimeOffsetMinutes;
    private Boolean isEnabled;
    private OffsetDateTime nextRun;
    private Double nextRunOffsetMinutes;
    private Long interval;
    private ScheduleFrequency frequency;
    private String timeZone;
    private AdvancedSchedule advancedSchedule;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private String description;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public SucScheduleProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public Double startTimeOffsetMinutes() {
        return this.startTimeOffsetMinutes;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public SucScheduleProperties withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public Double expiryTimeOffsetMinutes() {
        return this.expiryTimeOffsetMinutes;
    }

    public SucScheduleProperties withExpiryTimeOffsetMinutes(Double expiryTimeOffsetMinutes) {
        this.expiryTimeOffsetMinutes = expiryTimeOffsetMinutes;
        return this;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public SucScheduleProperties withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    public OffsetDateTime nextRun() {
        return this.nextRun;
    }

    public SucScheduleProperties withNextRun(OffsetDateTime nextRun) {
        this.nextRun = nextRun;
        return this;
    }

    public Double nextRunOffsetMinutes() {
        return this.nextRunOffsetMinutes;
    }

    public SucScheduleProperties withNextRunOffsetMinutes(Double nextRunOffsetMinutes) {
        this.nextRunOffsetMinutes = nextRunOffsetMinutes;
        return this;
    }

    public Long interval() {
        return this.interval;
    }

    public SucScheduleProperties withInterval(Long interval) {
        this.interval = interval;
        return this;
    }

    public ScheduleFrequency frequency() {
        return this.frequency;
    }

    public SucScheduleProperties withFrequency(ScheduleFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public SucScheduleProperties withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public AdvancedSchedule advancedSchedule() {
        return this.advancedSchedule;
    }

    public SucScheduleProperties withAdvancedSchedule(AdvancedSchedule advancedSchedule) {
        this.advancedSchedule = advancedSchedule;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public SucScheduleProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public SucScheduleProperties withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SucScheduleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.advancedSchedule() != null) {
            this.advancedSchedule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("expiryTime", this.expiryTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiryTime));
        jsonWriter.writeNumberField("expiryTimeOffsetMinutes", (Number)this.expiryTimeOffsetMinutes);
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeStringField("nextRun", this.nextRun == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextRun));
        jsonWriter.writeNumberField("nextRunOffsetMinutes", (Number)this.nextRunOffsetMinutes);
        jsonWriter.writeNumberField("interval", (Number)this.interval);
        jsonWriter.writeStringField("frequency", this.frequency == null ? null : this.frequency.toString());
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeJsonField("advancedSchedule", (JsonSerializable)this.advancedSchedule);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static SucScheduleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SucScheduleProperties)jsonReader.readObject(reader -> {
            SucScheduleProperties deserializedSucScheduleProperties = new SucScheduleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedSucScheduleProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startTimeOffsetMinutes".equals(fieldName)) {
                    deserializedSucScheduleProperties.startTimeOffsetMinutes = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedSucScheduleProperties.expiryTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expiryTimeOffsetMinutes".equals(fieldName)) {
                    deserializedSucScheduleProperties.expiryTimeOffsetMinutes = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("isEnabled".equals(fieldName)) {
                    deserializedSucScheduleProperties.isEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("nextRun".equals(fieldName)) {
                    deserializedSucScheduleProperties.nextRun = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("nextRunOffsetMinutes".equals(fieldName)) {
                    deserializedSucScheduleProperties.nextRunOffsetMinutes = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedSucScheduleProperties.interval = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("frequency".equals(fieldName)) {
                    deserializedSucScheduleProperties.frequency = ScheduleFrequency.fromString(reader.getString());
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedSucScheduleProperties.timeZone = reader.getString();
                    continue;
                }
                if ("advancedSchedule".equals(fieldName)) {
                    deserializedSucScheduleProperties.advancedSchedule = AdvancedSchedule.fromJson(reader);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedSucScheduleProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedSucScheduleProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSucScheduleProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSucScheduleProperties;
        });
    }
}

