/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.TagOperators;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class TagSettingsProperties
implements JsonSerializable<TagSettingsProperties> {
    private Map<String, List<String>> tags;
    private TagOperators filterOperator;

    public Map<String, List<String>> tags() {
        return this.tags;
    }

    public TagSettingsProperties withTags(Map<String, List<String>> tags) {
        this.tags = tags;
        return this;
    }

    public TagOperators filterOperator() {
        return this.filterOperator;
    }

    public TagSettingsProperties withFilterOperator(TagOperators filterOperator) {
        this.filterOperator = filterOperator;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeArray((Iterable)element, (writer1, element1) -> writer1.writeString(element1)));
        jsonWriter.writeStringField("filterOperator", this.filterOperator == null ? null : this.filterOperator.toString());
        return jsonWriter.writeEndObject();
    }

    public static TagSettingsProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TagSettingsProperties)jsonReader.readObject(reader -> {
            TagSettingsProperties deserializedTagSettingsProperties = new TagSettingsProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedTagSettingsProperties.tags = tags = reader.readMap(reader1 -> reader1.readArray(reader2 -> reader2.getString()));
                    continue;
                }
                if ("filterOperator".equals(fieldName)) {
                    deserializedTagSettingsProperties.filterOperator = TagOperators.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTagSettingsProperties;
        });
    }
}

