/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.AzureQueryProperties;
import com.azure.resourcemanager.automation.models.NonAzureQueryProperties;
import java.io.IOException;
import java.util.List;

public final class TargetProperties
implements JsonSerializable<TargetProperties> {
    private List<AzureQueryProperties> azureQueries;
    private List<NonAzureQueryProperties> nonAzureQueries;

    public List<AzureQueryProperties> azureQueries() {
        return this.azureQueries;
    }

    public TargetProperties withAzureQueries(List<AzureQueryProperties> azureQueries) {
        this.azureQueries = azureQueries;
        return this;
    }

    public List<NonAzureQueryProperties> nonAzureQueries() {
        return this.nonAzureQueries;
    }

    public TargetProperties withNonAzureQueries(List<NonAzureQueryProperties> nonAzureQueries) {
        this.nonAzureQueries = nonAzureQueries;
        return this;
    }

    public void validate() {
        if (this.azureQueries() != null) {
            this.azureQueries().forEach(e -> e.validate());
        }
        if (this.nonAzureQueries() != null) {
            this.nonAzureQueries().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("azureQueries", this.azureQueries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("nonAzureQueries", this.nonAzureQueries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TargetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TargetProperties)jsonReader.readObject(reader -> {
            TargetProperties deserializedTargetProperties = new TargetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azureQueries".equals(fieldName)) {
                    List azureQueries;
                    deserializedTargetProperties.azureQueries = azureQueries = reader.readArray(reader1 -> AzureQueryProperties.fromJson(reader1));
                    continue;
                }
                if ("nonAzureQueries".equals(fieldName)) {
                    List nonAzureQueries;
                    deserializedTargetProperties.nonAzureQueries = nonAzureQueries = reader.readArray(reader1 -> NonAzureQueryProperties.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetProperties;
        });
    }
}

