/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.models.LinuxProperties;
import com.azure.resourcemanager.automation.models.OperatingSystemType;
import com.azure.resourcemanager.automation.models.TargetProperties;
import com.azure.resourcemanager.automation.models.WindowsProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class UpdateConfiguration
implements JsonSerializable<UpdateConfiguration> {
    private OperatingSystemType operatingSystem;
    private WindowsProperties windows;
    private LinuxProperties linux;
    private Duration duration;
    private List<String> azureVirtualMachines;
    private List<String> nonAzureComputerNames;
    private TargetProperties targets;
    private static final ClientLogger LOGGER = new ClientLogger(UpdateConfiguration.class);

    public OperatingSystemType operatingSystem() {
        return this.operatingSystem;
    }

    public UpdateConfiguration withOperatingSystem(OperatingSystemType operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public WindowsProperties windows() {
        return this.windows;
    }

    public UpdateConfiguration withWindows(WindowsProperties windows) {
        this.windows = windows;
        return this;
    }

    public LinuxProperties linux() {
        return this.linux;
    }

    public UpdateConfiguration withLinux(LinuxProperties linux) {
        this.linux = linux;
        return this;
    }

    public Duration duration() {
        return this.duration;
    }

    public UpdateConfiguration withDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public List<String> azureVirtualMachines() {
        return this.azureVirtualMachines;
    }

    public UpdateConfiguration withAzureVirtualMachines(List<String> azureVirtualMachines) {
        this.azureVirtualMachines = azureVirtualMachines;
        return this;
    }

    public List<String> nonAzureComputerNames() {
        return this.nonAzureComputerNames;
    }

    public UpdateConfiguration withNonAzureComputerNames(List<String> nonAzureComputerNames) {
        this.nonAzureComputerNames = nonAzureComputerNames;
        return this;
    }

    public TargetProperties targets() {
        return this.targets;
    }

    public UpdateConfiguration withTargets(TargetProperties targets) {
        this.targets = targets;
        return this;
    }

    public void validate() {
        if (this.operatingSystem() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operatingSystem in model UpdateConfiguration"));
        }
        if (this.windows() != null) {
            this.windows().validate();
        }
        if (this.linux() != null) {
            this.linux().validate();
        }
        if (this.targets() != null) {
            this.targets().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operatingSystem", this.operatingSystem == null ? null : this.operatingSystem.toString());
        jsonWriter.writeJsonField("windows", (JsonSerializable)this.windows);
        jsonWriter.writeJsonField("linux", (JsonSerializable)this.linux);
        jsonWriter.writeStringField("duration", CoreUtils.durationToStringWithDays((Duration)this.duration));
        jsonWriter.writeArrayField("azureVirtualMachines", this.azureVirtualMachines, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("nonAzureComputerNames", this.nonAzureComputerNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("targets", (JsonSerializable)this.targets);
        return jsonWriter.writeEndObject();
    }

    public static UpdateConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (UpdateConfiguration)jsonReader.readObject(reader -> {
            UpdateConfiguration deserializedUpdateConfiguration = new UpdateConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operatingSystem".equals(fieldName)) {
                    deserializedUpdateConfiguration.operatingSystem = OperatingSystemType.fromString(reader.getString());
                    continue;
                }
                if ("windows".equals(fieldName)) {
                    deserializedUpdateConfiguration.windows = WindowsProperties.fromJson(reader);
                    continue;
                }
                if ("linux".equals(fieldName)) {
                    deserializedUpdateConfiguration.linux = LinuxProperties.fromJson(reader);
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedUpdateConfiguration.duration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("azureVirtualMachines".equals(fieldName)) {
                    List azureVirtualMachines;
                    deserializedUpdateConfiguration.azureVirtualMachines = azureVirtualMachines = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("nonAzureComputerNames".equals(fieldName)) {
                    List nonAzureComputerNames;
                    deserializedUpdateConfiguration.nonAzureComputerNames = nonAzureComputerNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("targets".equals(fieldName)) {
                    deserializedUpdateConfiguration.targets = TargetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUpdateConfiguration;
        });
    }
}

