/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.VariableCreateOrUpdateProperties;
import java.io.IOException;

public final class VariableCreateOrUpdateParameters
implements JsonSerializable<VariableCreateOrUpdateParameters> {
    private String name;
    private VariableCreateOrUpdateProperties innerProperties = new VariableCreateOrUpdateProperties();
    private static final ClientLogger LOGGER = new ClientLogger(VariableCreateOrUpdateParameters.class);

    public String name() {
        return this.name;
    }

    public VariableCreateOrUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private VariableCreateOrUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public VariableCreateOrUpdateParameters withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VariableCreateOrUpdateProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public VariableCreateOrUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VariableCreateOrUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Boolean isEncrypted() {
        return this.innerProperties() == null ? null : this.innerProperties().isEncrypted();
    }

    public VariableCreateOrUpdateParameters withIsEncrypted(Boolean isEncrypted) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VariableCreateOrUpdateProperties();
        }
        this.innerProperties().withIsEncrypted(isEncrypted);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model VariableCreateOrUpdateParameters"));
        }
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model VariableCreateOrUpdateParameters"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VariableCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VariableCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            VariableCreateOrUpdateParameters deserializedVariableCreateOrUpdateParameters = new VariableCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVariableCreateOrUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVariableCreateOrUpdateParameters.innerProperties = VariableCreateOrUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVariableCreateOrUpdateParameters;
        });
    }
}

