/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.VariableInner;
import java.io.IOException;
import java.util.List;

public final class VariableListResult
implements JsonSerializable<VariableListResult> {
    private List<VariableInner> value;
    private String nextLink;

    public List<VariableInner> value() {
        return this.value;
    }

    public VariableListResult withValue(List<VariableInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public VariableListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static VariableListResult fromJson(JsonReader jsonReader) throws IOException {
        return (VariableListResult)jsonReader.readObject(reader -> {
            VariableListResult deserializedVariableListResult = new VariableListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVariableListResult.value = value = reader.readArray(reader1 -> VariableInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedVariableListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVariableListResult;
        });
    }
}

