/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.automation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.automation.fluent.models.VariableUpdateProperties;
import java.io.IOException;

public final class VariableUpdateParameters
implements JsonSerializable<VariableUpdateParameters> {
    private String name;
    private VariableUpdateProperties innerProperties;

    public String name() {
        return this.name;
    }

    public VariableUpdateParameters withName(String name) {
        this.name = name;
        return this;
    }

    private VariableUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public VariableUpdateParameters withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VariableUpdateProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public VariableUpdateParameters withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VariableUpdateProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VariableUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VariableUpdateParameters)jsonReader.readObject(reader -> {
            VariableUpdateParameters deserializedVariableUpdateParameters = new VariableUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVariableUpdateParameters.name = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVariableUpdateParameters.innerProperties = VariableUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVariableUpdateParameters;
        });
    }
}

